﻿Public Class NaiveGradientButton
    Inherits Button
    Private gradientStop1, gradientStop2 As GradientStop


    Public Sub New()
        Dim brush As New LinearGradientBrush()
        brush.StartPoint = New Point(0, 0)
        brush.EndPoint = New Point(1, 0)

        gradientStop1 = New GradientStop()
        gradientStop1.Offset = 0
        brush.GradientStops.Add(gradientStop1)

        gradientStop2 = New GradientStop()
        gradientStop2.Offset = 1
        brush.GradientStops.Add(gradientStop2)

        Foreground = brush
    End Sub


    Public Property Color1() As Color
        Set(ByVal value As Color)
            gradientStop1.Color = value
        End Set
        Get
            Return CType(gradientStop1.Color, Color)
        End Get
    End Property


    Public Property Color2() As Color
        Set(ByVal value As Color)
            gradientStop2.Color = value
        End Set
        Get
            Return CType(gradientStop2.Color, Color)
        End Get
    End Property
End Class
